/*
  ==============================================================================

  This is an automatically generated GUI class created by the Introjucer!

  Be careful when adding custom code to these files, as only the code within
  the "//[xyz]" and "//[/xyz]" sections will be retained when the file is loaded
  and re-saved.

  Created with Introjucer version: 3.1.0

  ------------------------------------------------------------------------------

  The Introjucer is part of the JUCE library - "Jules' Utility Class Extensions"
  Copyright 2004-13 by Raw Material Software Ltd.

  ==============================================================================
*/

#ifndef __JUCE_HEADER_2F798B334A9C61CC__
#define __JUCE_HEADER_2F798B334A9C61CC__

//[Headers]     -- You can add your own extra header files here --
#include "JuceHeader.h"

class MainComponent;
//[/Headers]



//==============================================================================
/**
                                                                    //[Comments]
    An auto-generated component, created by the Introjucer.

    Describe your class and how it works here!
                                                                    //[/Comments]
*/
class GameListPanel  : public Component,
                       public TableListBoxModel,
                       public ChangeListener,
                       public ButtonListener
{
public:
    //==============================================================================
    GameListPanel (MainContentComponent& mainComp);
    ~GameListPanel();

    //==============================================================================
    //[UserMethods]     -- You can add your own custom methods in this section.

	///	So we update settings when the user edits something.
	void changeListenerCallback(ChangeBroadcaster *source);

    /// Returns the number of rows in our list box.
    int getNumRows() {return mainComponent.getGames().size();};
    /// Draws the background of a row in the list box.
    void paintRowBackground(Graphics &g,
                            int rowNumber,
                            int width,
                            int height,
                            bool rowIsSelected);
    /// Draws a cell in the list box.
    void paintCell(Graphics &g,
                   int rowNumber,
                   int columnId,
                   int width,
                   int height,
                   bool rowIsSelected);
    /// Called when the user selects a game.
    void cellClicked(int rowNumber, int columnId, const MouseEvent &e);
    /// Used to launch a game via double-click.
    void cellDoubleClicked(int rowNumber, int columnId, const MouseEvent &e);

    //[/UserMethods]

    void paint (Graphics& g);
    void resized();
    void buttonClicked (Button* buttonThatWasClicked);



private:
    //[UserVariables]   -- You can add your own custom variables in this section.

	///	Struct holding the settings for each game in the list.
	struct SavedSettings
	{
		///	The EXCOSC listen port.
		String listenPort;
		///	The EXCOSC send address.
		String sendAddress;
		///	The EXCOSC send port.
		String sendPort;
		///	The EXCOSC 'add to patcher' toggle.
		bool addPortsToPatcher;
		///	The command line arguments.
		String commandLine;

		///	Constructor to fill out the EXCOSC stuff with sensible defaults.
		SavedSettings():
		listenPort("5678"),
		sendAddress("127.0.0.1"),
		sendPort("10001"),
		addPortsToPatcher(false)
		{

		};
	};

    /// Helper method. Launches the selected game.
    void launchSelectedGame();

    /// Our copy of the MainComponent.
    MainContentComponent& mainComponent;

    /// The screenshot Image.
    Image *screenshot;

	///	Holds saved settings for each game.
	OwnedArray<SavedSettings> settings;
	///	The index of the currently-selected game.
	int selectedGame;

    //[/UserVariables]

    //==============================================================================
    ScopedPointer<TableListBox> gameList;
    ScopedPointer<Label> gameNameLabel;
    ScopedPointer<Label> gameAuthorLabel;
    ScopedPointer<Label> gameDescLabel;
    ScopedPointer<TextButton> launchGameButton;
    ScopedPointer<TabbedComponent> optionsTabs;


    //==============================================================================
    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (GameListPanel)
};

//[EndFile] You can add extra defines here...
//[/EndFile]

#endif   // __JUCE_HEADER_2F798B334A9C61CC__
